#ifndef _TLK_SCLK__ATP_TESTS_H_
#define _TLK_SCLK__ATP_TESTS_H_


#ifdef __cplusplus
extern "C"
{
#endif

  /*
  *  Object %name    : %
  *  State           :  %state%
  *  Creation date   :  6-Nov-08
  *  Last modified   :  %modify_time%
  */
  /** @file
  *  \brief A brief description of this module
  *
  *  \version TLK_SCLK_ATP_tests.h#1:incl:1
  *  \author LironD
  *  \remarks Copyright (C) 2008 by Discretix Technologies Ltd.
  *           All Rights reserved
  */

  /*****************************************************************************
  * Function Name:
  *  TST_ATP_TLK_SCLK_ServiceClkGenAndServiceClkRead.
  * 
  * Inputs:
  *  None
  *
  * Outputs:
  *  DxError_t - Function error return
  *
  * Description:
  *    Test the generation of a new service clock. 
  *    Using TLK_SCLK_ServiceClkGen and TLK_SCLK_ServiceClkRead. 
  *    Those functions generate a new descriptor for secured service clock ,
  *    then read it to verify integrity.
  *  
  * Algorithm:
  * 1.	Initialize the new master clock descriptor using TLK_SCLK_Init.
  * 2.	Call TLK_SCLK_WorkspaceSizeGet and get workspace size.
  * 3.	Load parameters and call TLK_SCLK_ServiceClkGen generate a new descriptor for secured service clock.
  * 4.	Call TLK_SCLK_ServiceClkRead using the descriptor and NULL application ID
  *     (the time format is TLK_SCLK_SECONDS_SINCE_FORMAT). 
  * 5.	validate that the service clock descriptor is as expected:
  *      a.	Compare the service clock status with the expected status.
  *      b.	Get the system time and compare it to the returned service clock time
  *******************************************************************************/
  DxError_t TST_ATP_TLK_SCLK_ServiceClkGenAndServiceClkRead(void);

  /*****************************************************************************
  * Function Name:
  *  TST_ATP_TLK_SCLK_ServiceClkRevalidation.
  * 
  * Inputs:
  *  None
  *
  * Outputs:
  *  DxError_t - Function error return
  *
  * Description:
  *    Test the revalidation of the service clock alone. 
  *    Using Time Toolkit API TLK_SCLK_ServiceClkGen to generate a new descriptor
  *    for secured service clock,  then call the Time Toolkit API 
  *    TLK_SCLK_MCServiceClkRevalidate with new time (in the master clock offset limit). 
  *  
  * Algorithm:
  * 1.	Initialize the new master clock descriptor using TLK_SCLK_Init.
  * 2.	Call TLK_SCLK_WorkspaceSizeGet and get workspace size.
  * 3.	Load parameters and call TLK_SCLK_ServiceClkGen generate a new descriptor for secured service clock.
  * 4.	Call TLK_SCLK_ServiceClkRead  - read the current time from the service secured clock descriptor.
  * 5.	Initialize new time according to the parameter received from the previous operation.
  * 6.	Call TLK_SCLK_MCServiceClkRevalidate with the new time. 
  * 7.	Call TLK_SCLK_ServiceClkRead using the descriptor and the application ID received from the previous operation.
  * 8.	validate that the service clock descriptors is as expected:
  *    a.	Compare the service clock status with the expected.
  *    b.	Compare the new time with the returned service clock time. 
  *******************************************************************************/
  DxError_t TST_ATP_TLK_SCLK_ServiceClkRevalidation(void);

 
  /*****************************************************************************
  * Function Name:
  *  TLK_SCLK_ATP_Master_Clk_Update.
  * 
  * Inputs:
  *  None
  *
  * Outputs:
  *  DxError_t - Function error return
  *
  * Description:
  *   To test the periodic update of the master clock by creating a service 
  *   clock descriptor. Using the Secure Time Toolkit API TLK_SCLK_ServiceClkRead
  *   and Secure Time Toolkit API TLK_SCLK_ServiceClkGen.
  *  
  * Algorithm:
  * 1.	Initialize the new master clock descriptor using TLK_SCLK_Init.
  * 2.	Call TLK_SCLK_WorkspaceSizeGet and get workspace size.
  * 3.	Load parameters and call TLK_SCLK_ServiceClkGen generate new descriptor for secured service clock.
  * 4.	Call TLK_SCLK_ServiceClkRead  - read the current time from the service secured clock descriptor.
  * 5.	Wait the required time for the master clock to update.
  * 6.	Call TLK_SCLK_ServiceClkRead  - read the new updated time from the service secured clock descriptor.
  * 7.	validate that the service clock descriptor is as expected :
  *     a.	Compare the service clock status with the expected.
  *     b.	Compare the new time with the returned service clock time
  *******************************************************************************/
  DxError_t TLK_SCLK_ATP_Master_Clk_Update(void);

  /*****************************************************************************
  * Function Name:
  *  TLK_SCLK_ATP_Service_Clk_Validity_Grace_Period.
  * 
  * Inputs:
  *  None
  *
  * Outputs:
  *  DxError_t - Function error return
  *
  * Description:
  *  To test the output parameters of Secure Time Toolkit API's TLK_SCLK_ServiceClkRead
  *  when the service descriptor is no longer valid (period expired) and during "grace period".
  *  
  * Algorithm:
  * 1.	Load parameters and call TLK_SCLK_ServiceClkGen generate new descriptor for secured service clock.
  * 2     Call TLK_SCLK_MCServiceClkRevalidate with the system time
  * 3.	Call TLK_SCLK_ServiceClkRead  - read the current time from the service secured clock descriptor.
  * 4.	Wait the required time until the service descriptor enters its grace period.
  * 5.	Call TLK_SCLK_ServiceClkRead  - read the new updated time from the service secured clock descriptor.
  * 6.	validate that the service clock descriptor is as expected :
  *   a.	Compare the service clock status with the expected.
  *   b.	Compare the return time with the expected .
  * 7.	Wait the required time until the service descriptor no longer valid.
  * 8.	Call TLK_SCLK_ServiceClkRead.
  * 9.	validate that the service clock descriptor is as expected :
  *   a.	Compare the service clock status with the expected.
  *   b.	Compare the return time with the expected .
  *******************************************************************************/

  DxError_t TLK_SCLK_ATP_Service_Clk_Validity_Grace_Period(void);

  /*****************************************************************************
  * Function Name:
  *  TLK_SCLK_ATP_Authenticate.
  * 
  * Inputs:
  *  None
  *
  * Outputs:
  *  DxError_t - Function error return
  *
  * Description:
  *  To test Toolkit API TLK_SCLK_ServiceClkAuthenticate. 
  *  The test calls to the API TLK_SCLK_ServiceClkAuthenticate and see that the returned parameters are as expected.
  *
  * Algorithm:
  * 1.	Call TLK_SCLK_ServiceClkGen. 
  * 2.	Call TLK_SCLK_MCServiceClkRevalidate with ServiceClockDrift.
  * 3.	Call TLK_SCLK_ServiceClkAuthenticate.
  * 4.	returned parameters are as expected.
  *	 a.	Compare the service clock cookie with the returned cookie. 
  *	 b.	Compare the service clock offset with the returned offset. 
  ******************************************************************************/
  DxError_t TLK_SCLK_ATP_Authenticate (void);


#ifdef __cplusplus
}
#endif

#endif
